<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <div class="app-title">
        <div>
            <h1><i class="fa fa-info-circle"></i> <?php echo e($page_title); ?></h1>
        </div>
        <ul class="app-breadcrumb breadcrumb">
            <li class="breadcrumb-item"><i class="fa fa-home fa-lg"></i></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url()->current()); ?>"><?php echo e($page_title); ?></a></li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="tile">
                <h3 class="tile-title"><?php echo e($page_title); ?></h3>
                <div class="tile-body">
                    <form class="form-horizontal" method="post" role="form">
                        <?php echo csrf_field(); ?>

                        <div class="form-body">

                            <div class="form-group<?php echo e($errors->has('terms') ? ' has-error' : ''); ?>">
                                <label class="col-md-12"><strong style="text-transform: uppercase;">Terms & Condition</strong></label>
                                <div class="col-md-12">
                                    <textarea id="area1" class="form-control" rows="15"
                                              name="terms"><?php echo e($basic->terms); ?></textarea>
                                    <?php if($errors->has('terms')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('terms')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-primary btn-block btn-lg"><i
                                            class="fa fa-send"></i> Update Terms & Condition
                                </button>
                            </div>


                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript" src="<?php echo e(asset('assets/admin/js/nicEdit-latest.js')); ?>"></script>
    <script>
        bkLib.onDomLoaded(function () {
            new nicEditor({fullPanel: true}).panelInstance('area1');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>